// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Operates on the allowed values for the matchVariable. </summary>
    public readonly partial struct ExceptionEntryValueMatchOperator : IEquatable<ExceptionEntryValueMatchOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExceptionEntryValueMatchOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExceptionEntryValueMatchOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsValueValue = "Equals";
        private const string ContainsValue = "Contains";
        private const string StartsWithValue = "StartsWith";
        private const string EndsWithValue = "EndsWith";
        private const string IPMatchValue = "IPMatch";

        /// <summary> Equals. </summary>
        public static ExceptionEntryValueMatchOperator EqualsValue { get; } = new ExceptionEntryValueMatchOperator(EqualsValueValue);
        /// <summary> Contains. </summary>
        public static ExceptionEntryValueMatchOperator Contains { get; } = new ExceptionEntryValueMatchOperator(ContainsValue);
        /// <summary> StartsWith. </summary>
        public static ExceptionEntryValueMatchOperator StartsWith { get; } = new ExceptionEntryValueMatchOperator(StartsWithValue);
        /// <summary> EndsWith. </summary>
        public static ExceptionEntryValueMatchOperator EndsWith { get; } = new ExceptionEntryValueMatchOperator(EndsWithValue);
        /// <summary> IPMatch. </summary>
        public static ExceptionEntryValueMatchOperator IPMatch { get; } = new ExceptionEntryValueMatchOperator(IPMatchValue);
        /// <summary> Determines if two <see cref="ExceptionEntryValueMatchOperator"/> values are the same. </summary>
        public static bool operator ==(ExceptionEntryValueMatchOperator left, ExceptionEntryValueMatchOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExceptionEntryValueMatchOperator"/> values are not the same. </summary>
        public static bool operator !=(ExceptionEntryValueMatchOperator left, ExceptionEntryValueMatchOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExceptionEntryValueMatchOperator"/>. </summary>
        public static implicit operator ExceptionEntryValueMatchOperator(string value) => new ExceptionEntryValueMatchOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExceptionEntryValueMatchOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExceptionEntryValueMatchOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
