// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> When the matchVariable points to a key-value pair (e.g, RequestHeader), this operates on the selector. </summary>
    public readonly partial struct ExceptionEntrySelectorMatchOperator : IEquatable<ExceptionEntrySelectorMatchOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExceptionEntrySelectorMatchOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExceptionEntrySelectorMatchOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsValueValue = "Equals";
        private const string ContainsValue = "Contains";
        private const string StartsWithValue = "StartsWith";
        private const string EndsWithValue = "EndsWith";

        /// <summary> Equals. </summary>
        public static ExceptionEntrySelectorMatchOperator EqualsValue { get; } = new ExceptionEntrySelectorMatchOperator(EqualsValueValue);
        /// <summary> Contains. </summary>
        public static ExceptionEntrySelectorMatchOperator Contains { get; } = new ExceptionEntrySelectorMatchOperator(ContainsValue);
        /// <summary> StartsWith. </summary>
        public static ExceptionEntrySelectorMatchOperator StartsWith { get; } = new ExceptionEntrySelectorMatchOperator(StartsWithValue);
        /// <summary> EndsWith. </summary>
        public static ExceptionEntrySelectorMatchOperator EndsWith { get; } = new ExceptionEntrySelectorMatchOperator(EndsWithValue);
        /// <summary> Determines if two <see cref="ExceptionEntrySelectorMatchOperator"/> values are the same. </summary>
        public static bool operator ==(ExceptionEntrySelectorMatchOperator left, ExceptionEntrySelectorMatchOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExceptionEntrySelectorMatchOperator"/> values are not the same. </summary>
        public static bool operator !=(ExceptionEntrySelectorMatchOperator left, ExceptionEntrySelectorMatchOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExceptionEntrySelectorMatchOperator"/>. </summary>
        public static implicit operator ExceptionEntrySelectorMatchOperator(string value) => new ExceptionEntrySelectorMatchOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExceptionEntrySelectorMatchOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExceptionEntrySelectorMatchOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
