// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The variable on which we evaluate the exception condition. </summary>
    public readonly partial struct ExceptionEntryMatchVariable : IEquatable<ExceptionEntryMatchVariable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExceptionEntryMatchVariable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExceptionEntryMatchVariable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequestUriValue = "RequestURI";
        private const string RemoteAddrValue = "RemoteAddr";
        private const string RequestHeaderValue = "RequestHeader";

        /// <summary> RequestURI. </summary>
        public static ExceptionEntryMatchVariable RequestUri { get; } = new ExceptionEntryMatchVariable(RequestUriValue);
        /// <summary> RemoteAddr. </summary>
        public static ExceptionEntryMatchVariable RemoteAddr { get; } = new ExceptionEntryMatchVariable(RemoteAddrValue);
        /// <summary> RequestHeader. </summary>
        public static ExceptionEntryMatchVariable RequestHeader { get; } = new ExceptionEntryMatchVariable(RequestHeaderValue);
        /// <summary> Determines if two <see cref="ExceptionEntryMatchVariable"/> values are the same. </summary>
        public static bool operator ==(ExceptionEntryMatchVariable left, ExceptionEntryMatchVariable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExceptionEntryMatchVariable"/> values are not the same. </summary>
        public static bool operator !=(ExceptionEntryMatchVariable left, ExceptionEntryMatchVariable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExceptionEntryMatchVariable"/>. </summary>
        public static implicit operator ExceptionEntryMatchVariable(string value) => new ExceptionEntryMatchVariable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExceptionEntryMatchVariable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExceptionEntryMatchVariable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
