// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Adds exception to allow a request when the condition is satisfied. </summary>
    public partial class ExceptionEntry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExceptionEntry"/>. </summary>
        /// <param name="matchVariable"> The variable on which we evaluate the exception condition. </param>
        /// <param name="valueMatchOperator"> Operates on the allowed values for the matchVariable. </param>
        public ExceptionEntry(ExceptionEntryMatchVariable matchVariable, ExceptionEntryValueMatchOperator valueMatchOperator)
        {
            MatchVariable = matchVariable;
            Values = new ChangeTrackingList<string>();
            ValueMatchOperator = valueMatchOperator;
            ExceptionManagedRuleSets = new ChangeTrackingList<ExclusionManagedRuleSet>();
        }

        /// <summary> Initializes a new instance of <see cref="ExceptionEntry"/>. </summary>
        /// <param name="matchVariable"> The variable on which we evaluate the exception condition. </param>
        /// <param name="values"> Allowed values for the matchVariable. </param>
        /// <param name="valueMatchOperator"> Operates on the allowed values for the matchVariable. </param>
        /// <param name="selectorMatchOperator"> When the matchVariable points to a key-value pair (e.g, RequestHeader), this operates on the selector. </param>
        /// <param name="selector"> When the matchVariable points to a key-value pair (e.g, RequestHeader), this identifies the key. </param>
        /// <param name="exceptionManagedRuleSets"> The managed rule sets that are associated with the exception. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExceptionEntry(ExceptionEntryMatchVariable matchVariable, IList<string> values, ExceptionEntryValueMatchOperator valueMatchOperator, ExceptionEntrySelectorMatchOperator? selectorMatchOperator, string selector, IList<ExclusionManagedRuleSet> exceptionManagedRuleSets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MatchVariable = matchVariable;
            Values = values;
            ValueMatchOperator = valueMatchOperator;
            SelectorMatchOperator = selectorMatchOperator;
            Selector = selector;
            ExceptionManagedRuleSets = exceptionManagedRuleSets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExceptionEntry"/> for deserialization. </summary>
        internal ExceptionEntry()
        {
        }

        /// <summary> The variable on which we evaluate the exception condition. </summary>
        public ExceptionEntryMatchVariable MatchVariable { get; set; }
        /// <summary> Allowed values for the matchVariable. </summary>
        public IList<string> Values { get; }
        /// <summary> Operates on the allowed values for the matchVariable. </summary>
        public ExceptionEntryValueMatchOperator ValueMatchOperator { get; set; }
        /// <summary> When the matchVariable points to a key-value pair (e.g, RequestHeader), this operates on the selector. </summary>
        public ExceptionEntrySelectorMatchOperator? SelectorMatchOperator { get; set; }
        /// <summary> When the matchVariable points to a key-value pair (e.g, RequestHeader), this identifies the key. </summary>
        public string Selector { get; set; }
        /// <summary> The managed rule sets that are associated with the exception. </summary>
        public IList<ExclusionManagedRuleSet> ExceptionManagedRuleSets { get; }
    }
}
