// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Results of network security group evaluation. </summary>
    public partial class EvaluatedNetworkSecurityGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EvaluatedNetworkSecurityGroup"/>. </summary>
        internal EvaluatedNetworkSecurityGroup()
        {
            RulesEvaluationResult = new ChangeTrackingList<NetworkSecurityRulesEvaluationResult>();
        }

        /// <summary> Initializes a new instance of <see cref="EvaluatedNetworkSecurityGroup"/>. </summary>
        /// <param name="networkSecurityGroupId"> Network security group ID. </param>
        /// <param name="appliedTo"> Resource ID of nic or subnet to which network security group is applied. </param>
        /// <param name="matchedRule"> Matched network security rule. </param>
        /// <param name="rulesEvaluationResult"> List of network security rules evaluation results. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EvaluatedNetworkSecurityGroup(ResourceIdentifier networkSecurityGroupId, string appliedTo, MatchedRule matchedRule, IReadOnlyList<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkSecurityGroupId = networkSecurityGroupId;
            AppliedTo = appliedTo;
            MatchedRule = matchedRule;
            RulesEvaluationResult = rulesEvaluationResult;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Network security group ID. </summary>
        public ResourceIdentifier NetworkSecurityGroupId { get; }
        /// <summary> Resource ID of nic or subnet to which network security group is applied. </summary>
        public string AppliedTo { get; }
        /// <summary> Matched network security rule. </summary>
        public MatchedRule MatchedRule { get; }
        /// <summary> List of network security rules evaluation results. </summary>
        public IReadOnlyList<NetworkSecurityRulesEvaluationResult> RulesEvaluationResult { get; }
    }
}
