// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Whether the rule is custom or default. </summary>
    internal readonly partial struct EffectiveAdminRuleKind : IEquatable<EffectiveAdminRuleKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EffectiveAdminRuleKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EffectiveAdminRuleKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "Custom";
        private const string DefaultValue = "Default";

        /// <summary> Custom. </summary>
        public static EffectiveAdminRuleKind Custom { get; } = new EffectiveAdminRuleKind(CustomValue);
        /// <summary> Default. </summary>
        public static EffectiveAdminRuleKind Default { get; } = new EffectiveAdminRuleKind(DefaultValue);
        /// <summary> Determines if two <see cref="EffectiveAdminRuleKind"/> values are the same. </summary>
        public static bool operator ==(EffectiveAdminRuleKind left, EffectiveAdminRuleKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EffectiveAdminRuleKind"/> values are not the same. </summary>
        public static bool operator !=(EffectiveAdminRuleKind left, EffectiveAdminRuleKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EffectiveAdminRuleKind"/>. </summary>
        public static implicit operator EffectiveAdminRuleKind(string value) => new EffectiveAdminRuleKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EffectiveAdminRuleKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EffectiveAdminRuleKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
