// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Determines whether BGP route propagation is enabled. Defaults to true. </summary>
    public readonly partial struct DisableBgpRoutePropagation : IEquatable<DisableBgpRoutePropagation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DisableBgpRoutePropagation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DisableBgpRoutePropagation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "False";
        private const string TrueValue = "True";

        /// <summary> False. </summary>
        public static DisableBgpRoutePropagation False { get; } = new DisableBgpRoutePropagation(FalseValue);
        /// <summary> True. </summary>
        public static DisableBgpRoutePropagation True { get; } = new DisableBgpRoutePropagation(TrueValue);
        /// <summary> Determines if two <see cref="DisableBgpRoutePropagation"/> values are the same. </summary>
        public static bool operator ==(DisableBgpRoutePropagation left, DisableBgpRoutePropagation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DisableBgpRoutePropagation"/> values are not the same. </summary>
        public static bool operator !=(DisableBgpRoutePropagation left, DisableBgpRoutePropagation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DisableBgpRoutePropagation"/>. </summary>
        public static implicit operator DisableBgpRoutePropagation(string value) => new DisableBgpRoutePropagation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DisableBgpRoutePropagation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DisableBgpRoutePropagation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
