// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Destination port behavior. </summary>
    public readonly partial struct DestinationPortBehavior : IEquatable<DestinationPortBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DestinationPortBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DestinationPortBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ListenIfAvailableValue = "ListenIfAvailable";

        /// <summary> None. </summary>
        public static DestinationPortBehavior None { get; } = new DestinationPortBehavior(NoneValue);
        /// <summary> ListenIfAvailable. </summary>
        public static DestinationPortBehavior ListenIfAvailable { get; } = new DestinationPortBehavior(ListenIfAvailableValue);
        /// <summary> Determines if two <see cref="DestinationPortBehavior"/> values are the same. </summary>
        public static bool operator ==(DestinationPortBehavior left, DestinationPortBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DestinationPortBehavior"/> values are not the same. </summary>
        public static bool operator !=(DestinationPortBehavior left, DestinationPortBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DestinationPortBehavior"/>. </summary>
        public static implicit operator DestinationPortBehavior(string value) => new DestinationPortBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DestinationPortBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DestinationPortBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
