// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Cross tenant scopes. </summary>
    public partial class CrossTenantScopes
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CrossTenantScopes"/>. </summary>
        internal CrossTenantScopes()
        {
            ManagementGroups = new ChangeTrackingList<string>();
            Subscriptions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CrossTenantScopes"/>. </summary>
        /// <param name="tenantId"> Tenant ID. </param>
        /// <param name="managementGroups"> List of management groups. </param>
        /// <param name="subscriptions"> List of subscriptions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CrossTenantScopes(Guid? tenantId, IReadOnlyList<string> managementGroups, IReadOnlyList<string> subscriptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            ManagementGroups = managementGroups;
            Subscriptions = subscriptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Tenant ID. </summary>
        public Guid? TenantId { get; }
        /// <summary> List of management groups. </summary>
        public IReadOnlyList<string> ManagementGroups { get; }
        /// <summary> List of subscriptions. </summary>
        public IReadOnlyList<string> Subscriptions { get; }
    }
}
