// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Test coverage for the endpoint. </summary>
    public readonly partial struct CoverageLevel : IEquatable<CoverageLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CoverageLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CoverageLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string LowValue = "Low";
        private const string BelowAverageValue = "BelowAverage";
        private const string AverageValue = "Average";
        private const string AboveAverageValue = "AboveAverage";
        private const string FullValue = "Full";

        /// <summary> Default. </summary>
        public static CoverageLevel Default { get; } = new CoverageLevel(DefaultValue);
        /// <summary> Low. </summary>
        public static CoverageLevel Low { get; } = new CoverageLevel(LowValue);
        /// <summary> BelowAverage. </summary>
        public static CoverageLevel BelowAverage { get; } = new CoverageLevel(BelowAverageValue);
        /// <summary> Average. </summary>
        public static CoverageLevel Average { get; } = new CoverageLevel(AverageValue);
        /// <summary> AboveAverage. </summary>
        public static CoverageLevel AboveAverage { get; } = new CoverageLevel(AboveAverageValue);
        /// <summary> Full. </summary>
        public static CoverageLevel Full { get; } = new CoverageLevel(FullValue);
        /// <summary> Determines if two <see cref="CoverageLevel"/> values are the same. </summary>
        public static bool operator ==(CoverageLevel left, CoverageLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CoverageLevel"/> values are not the same. </summary>
        public static bool operator !=(CoverageLevel left, CoverageLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CoverageLevel"/>. </summary>
        public static implicit operator CoverageLevel(string value) => new CoverageLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CoverageLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CoverageLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
