// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The type of issue. </summary>
    public readonly partial struct ConnectivityIssueType : IEquatable<ConnectivityIssueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectivityIssueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectivityIssueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AgentStoppedValue = "AgentStopped";
        private const string GuestFirewallValue = "GuestFirewall";
        private const string DnsResolutionValue = "DnsResolution";
        private const string SocketBindValue = "SocketBind";
        private const string NetworkSecurityRuleValue = "NetworkSecurityRule";
        private const string UserDefinedRouteValue = "UserDefinedRoute";
        private const string PortThrottledValue = "PortThrottled";
        private const string PlatformValue = "Platform";

        /// <summary> Unknown. </summary>
        public static ConnectivityIssueType Unknown { get; } = new ConnectivityIssueType(UnknownValue);
        /// <summary> AgentStopped. </summary>
        public static ConnectivityIssueType AgentStopped { get; } = new ConnectivityIssueType(AgentStoppedValue);
        /// <summary> GuestFirewall. </summary>
        public static ConnectivityIssueType GuestFirewall { get; } = new ConnectivityIssueType(GuestFirewallValue);
        /// <summary> DnsResolution. </summary>
        public static ConnectivityIssueType DnsResolution { get; } = new ConnectivityIssueType(DnsResolutionValue);
        /// <summary> SocketBind. </summary>
        public static ConnectivityIssueType SocketBind { get; } = new ConnectivityIssueType(SocketBindValue);
        /// <summary> NetworkSecurityRule. </summary>
        public static ConnectivityIssueType NetworkSecurityRule { get; } = new ConnectivityIssueType(NetworkSecurityRuleValue);
        /// <summary> UserDefinedRoute. </summary>
        public static ConnectivityIssueType UserDefinedRoute { get; } = new ConnectivityIssueType(UserDefinedRouteValue);
        /// <summary> PortThrottled. </summary>
        public static ConnectivityIssueType PortThrottled { get; } = new ConnectivityIssueType(PortThrottledValue);
        /// <summary> Platform. </summary>
        public static ConnectivityIssueType Platform { get; } = new ConnectivityIssueType(PlatformValue);
        /// <summary> Determines if two <see cref="ConnectivityIssueType"/> values are the same. </summary>
        public static bool operator ==(ConnectivityIssueType left, ConnectivityIssueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectivityIssueType"/> values are not the same. </summary>
        public static bool operator !=(ConnectivityIssueType left, ConnectivityIssueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectivityIssueType"/>. </summary>
        public static implicit operator ConnectivityIssueType(string value) => new ConnectivityIssueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectivityIssueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectivityIssueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
