// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Information on the connectivity status. </summary>
    public partial class ConnectivityInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityInformation"/>. </summary>
        internal ConnectivityInformation()
        {
            Hops = new ChangeTrackingList<ConnectivityHopInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityInformation"/>. </summary>
        /// <param name="hops"> List of hops between the source and the destination. </param>
        /// <param name="networkConnectionStatus"> The connection status. </param>
        /// <param name="avgLatencyInMs"> Average latency in milliseconds. </param>
        /// <param name="minLatencyInMs"> Minimum latency in milliseconds. </param>
        /// <param name="maxLatencyInMs"> Maximum latency in milliseconds. </param>
        /// <param name="probesSent"> Total number of probes sent. </param>
        /// <param name="probesFailed"> Number of failed probes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityInformation(IReadOnlyList<ConnectivityHopInfo> hops, NetworkConnectionStatus? networkConnectionStatus, int? avgLatencyInMs, int? minLatencyInMs, int? maxLatencyInMs, int? probesSent, int? probesFailed, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Hops = hops;
            NetworkConnectionStatus = networkConnectionStatus;
            AvgLatencyInMs = avgLatencyInMs;
            MinLatencyInMs = minLatencyInMs;
            MaxLatencyInMs = maxLatencyInMs;
            ProbesSent = probesSent;
            ProbesFailed = probesFailed;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of hops between the source and the destination. </summary>
        public IReadOnlyList<ConnectivityHopInfo> Hops { get; }
        /// <summary> The connection status. </summary>
        public NetworkConnectionStatus? NetworkConnectionStatus { get; }
        /// <summary> Average latency in milliseconds. </summary>
        public int? AvgLatencyInMs { get; }
        /// <summary> Minimum latency in milliseconds. </summary>
        public int? MinLatencyInMs { get; }
        /// <summary> Maximum latency in milliseconds. </summary>
        public int? MaxLatencyInMs { get; }
        /// <summary> Total number of probes sent. </summary>
        public int? ProbesSent { get; }
        /// <summary> Number of failed probes. </summary>
        public int? ProbesFailed { get; }
    }
}
