// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class ConnectivityInformation : IUtf8JsonSerializable, IJsonModel<ConnectivityInformation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConnectivityInformation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConnectivityInformation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectivityInformation)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsCollectionDefined(Hops))
            {
                writer.WritePropertyName("hops"u8);
                writer.WriteStartArray();
                foreach (var item in Hops)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(NetworkConnectionStatus))
            {
                writer.WritePropertyName("connectionStatus"u8);
                writer.WriteStringValue(NetworkConnectionStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(AvgLatencyInMs))
            {
                writer.WritePropertyName("avgLatencyInMs"u8);
                writer.WriteNumberValue(AvgLatencyInMs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinLatencyInMs))
            {
                writer.WritePropertyName("minLatencyInMs"u8);
                writer.WriteNumberValue(MinLatencyInMs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxLatencyInMs))
            {
                writer.WritePropertyName("maxLatencyInMs"u8);
                writer.WriteNumberValue(MaxLatencyInMs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProbesSent))
            {
                writer.WritePropertyName("probesSent"u8);
                writer.WriteNumberValue(ProbesSent.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProbesFailed))
            {
                writer.WritePropertyName("probesFailed"u8);
                writer.WriteNumberValue(ProbesFailed.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConnectivityInformation IJsonModel<ConnectivityInformation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectivityInformation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConnectivityInformation(document.RootElement, options);
        }

        internal static ConnectivityInformation DeserializeConnectivityInformation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ConnectivityHopInfo> hops = default;
            NetworkConnectionStatus? connectionStatus = default;
            int? avgLatencyInMs = default;
            int? minLatencyInMs = default;
            int? maxLatencyInMs = default;
            int? probesSent = default;
            int? probesFailed = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("hops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ConnectivityHopInfo> array = new List<ConnectivityHopInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConnectivityHopInfo.DeserializeConnectivityHopInfo(item, options));
                    }
                    hops = array;
                    continue;
                }
                if (property.NameEquals("connectionStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectionStatus = new NetworkConnectionStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("avgLatencyInMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    avgLatencyInMs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minLatencyInMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minLatencyInMs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxLatencyInMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxLatencyInMs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("probesSent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    probesSent = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("probesFailed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    probesFailed = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConnectivityInformation(
                hops ?? new ChangeTrackingList<ConnectivityHopInfo>(),
                connectionStatus,
                avgLatencyInMs,
                minLatencyInMs,
                maxLatencyInMs,
                probesSent,
                probesFailed,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConnectivityInformation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConnectivityInformation)} does not support writing '{options.Format}' format.");
            }
        }

        ConnectivityInformation IPersistableModel<ConnectivityInformation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConnectivityInformation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConnectivityInformation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConnectivityInformation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
