// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Information about a hop between the source and the destination. </summary>
    public partial class ConnectivityHopInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityHopInfo"/>. </summary>
        internal ConnectivityHopInfo()
        {
            NextHopIds = new ChangeTrackingList<string>();
            PreviousHopIds = new ChangeTrackingList<string>();
            Links = new ChangeTrackingList<HopLink>();
            PreviousLinks = new ChangeTrackingList<HopLink>();
            Issues = new ChangeTrackingList<ConnectivityIssueInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityHopInfo"/>. </summary>
        /// <param name="connectivityHopType"> The type of the hop. </param>
        /// <param name="id"> The ID of the hop. </param>
        /// <param name="address"> The IP address of the hop. </param>
        /// <param name="resourceId"> The ID of the resource corresponding to this hop. </param>
        /// <param name="nextHopIds"> List of next hop identifiers. </param>
        /// <param name="previousHopIds"> List of previous hop identifiers. </param>
        /// <param name="links"> List of hop links. </param>
        /// <param name="previousLinks"> List of previous hop links. </param>
        /// <param name="issues"> List of issues. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityHopInfo(string connectivityHopType, string id, string address, ResourceIdentifier resourceId, IReadOnlyList<string> nextHopIds, IReadOnlyList<string> previousHopIds, IReadOnlyList<HopLink> links, IReadOnlyList<HopLink> previousLinks, IReadOnlyList<ConnectivityIssueInfo> issues, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConnectivityHopType = connectivityHopType;
            Id = id;
            Address = address;
            ResourceId = resourceId;
            NextHopIds = nextHopIds;
            PreviousHopIds = previousHopIds;
            Links = links;
            PreviousLinks = previousLinks;
            Issues = issues;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of the hop. </summary>
        public string ConnectivityHopType { get; }
        /// <summary> The ID of the hop. </summary>
        public string Id { get; }
        /// <summary> The IP address of the hop. </summary>
        public string Address { get; }
        /// <summary> The ID of the resource corresponding to this hop. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> List of next hop identifiers. </summary>
        public IReadOnlyList<string> NextHopIds { get; }
        /// <summary> List of previous hop identifiers. </summary>
        public IReadOnlyList<string> PreviousHopIds { get; }
        /// <summary> List of hop links. </summary>
        public IReadOnlyList<HopLink> Links { get; }
        /// <summary> List of previous hop links. </summary>
        public IReadOnlyList<HopLink> PreviousLinks { get; }
        /// <summary> List of issues. </summary>
        public IReadOnlyList<ConnectivityIssueInfo> Issues { get; }
    }
}
