// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Connectivity group item. </summary>
    public partial class ConnectivityGroupItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectivityGroupItem"/>. </summary>
        /// <param name="networkGroupId"> Network group Id. </param>
        /// <param name="groupConnectivity"> Group connectivity type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkGroupId"/> is null. </exception>
        public ConnectivityGroupItem(string networkGroupId, GroupConnectivity groupConnectivity)
        {
            Argument.AssertNotNull(networkGroupId, nameof(networkGroupId));

            NetworkGroupId = networkGroupId;
            GroupConnectivity = groupConnectivity;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityGroupItem"/>. </summary>
        /// <param name="networkGroupId"> Network group Id. </param>
        /// <param name="useHubGateway"> Flag if need to use hub gateway. </param>
        /// <param name="isGlobal"> Flag if global is supported. </param>
        /// <param name="groupConnectivity"> Group connectivity type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectivityGroupItem(string networkGroupId, HubGatewayUsageFlag? useHubGateway, GlobalMeshSupportFlag? isGlobal, GroupConnectivity groupConnectivity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkGroupId = networkGroupId;
            UseHubGateway = useHubGateway;
            IsGlobal = isGlobal;
            GroupConnectivity = groupConnectivity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectivityGroupItem"/> for deserialization. </summary>
        internal ConnectivityGroupItem()
        {
        }

        /// <summary> Network group Id. </summary>
        public string NetworkGroupId { get; set; }
        /// <summary> Flag if need to use hub gateway. </summary>
        public HubGatewayUsageFlag? UseHubGateway { get; set; }
        /// <summary> Flag if global is supported. </summary>
        public GlobalMeshSupportFlag? IsGlobal { get; set; }
        /// <summary> Group connectivity type. </summary>
        public GroupConnectivity GroupConnectivity { get; set; }
    }
}
