// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class ConnectivityContent : IUtf8JsonSerializable, IJsonModel<ConnectivityContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConnectivityContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConnectivityContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectivityContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("source"u8);
            writer.WriteObjectValue(Source, options);
            writer.WritePropertyName("destination"u8);
            writer.WriteObjectValue(Destination, options);
            if (Optional.IsDefined(Protocol))
            {
                writer.WritePropertyName("protocol"u8);
                writer.WriteStringValue(Protocol.Value.ToString());
            }
            if (Optional.IsDefined(ProtocolConfiguration))
            {
                writer.WritePropertyName("protocolConfiguration"u8);
                writer.WriteObjectValue(ProtocolConfiguration, options);
            }
            if (Optional.IsDefined(PreferredIPVersion))
            {
                writer.WritePropertyName("preferredIPVersion"u8);
                writer.WriteStringValue(PreferredIPVersion.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConnectivityContent IJsonModel<ConnectivityContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectivityContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConnectivityContent(document.RootElement, options);
        }

        internal static ConnectivityContent DeserializeConnectivityContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ConnectivitySource source = default;
            ConnectivityDestination destination = default;
            NetworkWatcherProtocol? protocol = default;
            ProtocolConfiguration protocolConfiguration = default;
            NetworkIPVersion? preferredIPVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("source"u8))
                {
                    source = ConnectivitySource.DeserializeConnectivitySource(property.Value, options);
                    continue;
                }
                if (property.NameEquals("destination"u8))
                {
                    destination = ConnectivityDestination.DeserializeConnectivityDestination(property.Value, options);
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protocol = new NetworkWatcherProtocol(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("protocolConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protocolConfiguration = ProtocolConfiguration.DeserializeProtocolConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("preferredIPVersion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preferredIPVersion = new NetworkIPVersion(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConnectivityContent(
                source,
                destination,
                protocol,
                protocolConfiguration,
                preferredIPVersion,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConnectivityContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConnectivityContent)} does not support writing '{options.Format}' format.");
            }
        }

        ConnectivityContent IPersistableModel<ConnectivityContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectivityContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConnectivityContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConnectivityContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConnectivityContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
