// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The protocol to use in test evaluation. </summary>
    public readonly partial struct ConnectionMonitorTestConfigurationProtocol : IEquatable<ConnectionMonitorTestConfigurationProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorTestConfigurationProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionMonitorTestConfigurationProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "Tcp";
        private const string HttpValue = "Http";
        private const string IcmpValue = "Icmp";

        /// <summary> Tcp. </summary>
        public static ConnectionMonitorTestConfigurationProtocol Tcp { get; } = new ConnectionMonitorTestConfigurationProtocol(TcpValue);
        /// <summary> Http. </summary>
        public static ConnectionMonitorTestConfigurationProtocol Http { get; } = new ConnectionMonitorTestConfigurationProtocol(HttpValue);
        /// <summary> Icmp. </summary>
        public static ConnectionMonitorTestConfigurationProtocol Icmp { get; } = new ConnectionMonitorTestConfigurationProtocol(IcmpValue);
        /// <summary> Determines if two <see cref="ConnectionMonitorTestConfigurationProtocol"/> values are the same. </summary>
        public static bool operator ==(ConnectionMonitorTestConfigurationProtocol left, ConnectionMonitorTestConfigurationProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionMonitorTestConfigurationProtocol"/> values are not the same. </summary>
        public static bool operator !=(ConnectionMonitorTestConfigurationProtocol left, ConnectionMonitorTestConfigurationProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionMonitorTestConfigurationProtocol"/>. </summary>
        public static implicit operator ConnectionMonitorTestConfigurationProtocol(string value) => new ConnectionMonitorTestConfigurationProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionMonitorTestConfigurationProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionMonitorTestConfigurationProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
