// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Describes a connection monitor output destination. </summary>
    public partial class ConnectionMonitorOutput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorOutput"/>. </summary>
        public ConnectionMonitorOutput()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorOutput"/>. </summary>
        /// <param name="outputType"> Connection monitor output destination type. Currently, only "Workspace" is supported. </param>
        /// <param name="workspaceSettings"> Describes the settings for producing output into a log analytics workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectionMonitorOutput(OutputType? outputType, ConnectionMonitorWorkspaceSettings workspaceSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OutputType = outputType;
            WorkspaceSettings = workspaceSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Connection monitor output destination type. Currently, only "Workspace" is supported. </summary>
        public OutputType? OutputType { get; set; }
        /// <summary> Describes the settings for producing output into a log analytics workspace. </summary>
        internal ConnectionMonitorWorkspaceSettings WorkspaceSettings { get; set; }
        /// <summary> Log analytics workspace resource ID. </summary>
        public ResourceIdentifier WorkspaceResourceId
        {
            get => WorkspaceSettings is null ? default : WorkspaceSettings.WorkspaceResourceId;
            set
            {
                if (WorkspaceSettings is null)
                    WorkspaceSettings = new ConnectionMonitorWorkspaceSettings();
                WorkspaceSettings.WorkspaceResourceId = value;
            }
        }
    }
}
