// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The behavior of the endpoint filter. Currently only 'Include' is supported. </summary>
    public readonly partial struct ConnectionMonitorEndpointFilterType : IEquatable<ConnectionMonitorEndpointFilterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorEndpointFilterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionMonitorEndpointFilterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncludeValue = "Include";

        /// <summary> Include. </summary>
        public static ConnectionMonitorEndpointFilterType Include { get; } = new ConnectionMonitorEndpointFilterType(IncludeValue);
        /// <summary> Determines if two <see cref="ConnectionMonitorEndpointFilterType"/> values are the same. </summary>
        public static bool operator ==(ConnectionMonitorEndpointFilterType left, ConnectionMonitorEndpointFilterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionMonitorEndpointFilterType"/> values are not the same. </summary>
        public static bool operator !=(ConnectionMonitorEndpointFilterType left, ConnectionMonitorEndpointFilterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionMonitorEndpointFilterType"/>. </summary>
        public static implicit operator ConnectionMonitorEndpointFilterType(string value) => new ConnectionMonitorEndpointFilterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionMonitorEndpointFilterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionMonitorEndpointFilterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
