// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Describes the destination of connection monitor. </summary>
    public partial class ConnectionMonitorDestination
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorDestination"/>. </summary>
        public ConnectionMonitorDestination()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorDestination"/>. </summary>
        /// <param name="resourceId"> The ID of the resource used as the destination by connection monitor. </param>
        /// <param name="address"> Address of the connection monitor destination (IP or domain name). </param>
        /// <param name="port"> The destination port used by connection monitor. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectionMonitorDestination(ResourceIdentifier resourceId, string address, int? port, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            Address = address;
            Port = port;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ID of the resource used as the destination by connection monitor. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> Address of the connection monitor destination (IP or domain name). </summary>
        public string Address { get; set; }
        /// <summary> The destination port used by connection monitor. </summary>
        public int? Port { get; set; }
    }
}
