// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The Geo for CIDR advertising. Should be an Geo code. </summary>
    public readonly partial struct CidrAdvertisingGeoCode : IEquatable<CidrAdvertisingGeoCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CidrAdvertisingGeoCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CidrAdvertisingGeoCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GlobalValue = "GLOBAL";
        private const string AfriValue = "AFRI";
        private const string ApacValue = "APAC";
        private const string EuroValue = "EURO";
        private const string LatamValue = "LATAM";
        private const string NamValue = "NAM";
        private const string MEValue = "ME";
        private const string OceaniaValue = "OCEANIA";
        private const string AQValue = "AQ";

        /// <summary> GLOBAL. </summary>
        public static CidrAdvertisingGeoCode Global { get; } = new CidrAdvertisingGeoCode(GlobalValue);
        /// <summary> AFRI. </summary>
        public static CidrAdvertisingGeoCode Afri { get; } = new CidrAdvertisingGeoCode(AfriValue);
        /// <summary> APAC. </summary>
        public static CidrAdvertisingGeoCode Apac { get; } = new CidrAdvertisingGeoCode(ApacValue);
        /// <summary> EURO. </summary>
        public static CidrAdvertisingGeoCode Euro { get; } = new CidrAdvertisingGeoCode(EuroValue);
        /// <summary> LATAM. </summary>
        public static CidrAdvertisingGeoCode Latam { get; } = new CidrAdvertisingGeoCode(LatamValue);
        /// <summary> NAM. </summary>
        public static CidrAdvertisingGeoCode Nam { get; } = new CidrAdvertisingGeoCode(NamValue);
        /// <summary> ME. </summary>
        public static CidrAdvertisingGeoCode ME { get; } = new CidrAdvertisingGeoCode(MEValue);
        /// <summary> OCEANIA. </summary>
        public static CidrAdvertisingGeoCode Oceania { get; } = new CidrAdvertisingGeoCode(OceaniaValue);
        /// <summary> AQ. </summary>
        public static CidrAdvertisingGeoCode AQ { get; } = new CidrAdvertisingGeoCode(AQValue);
        /// <summary> Determines if two <see cref="CidrAdvertisingGeoCode"/> values are the same. </summary>
        public static bool operator ==(CidrAdvertisingGeoCode left, CidrAdvertisingGeoCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CidrAdvertisingGeoCode"/> values are not the same. </summary>
        public static bool operator !=(CidrAdvertisingGeoCode left, CidrAdvertisingGeoCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CidrAdvertisingGeoCode"/>. </summary>
        public static implicit operator CidrAdvertisingGeoCode(string value) => new CidrAdvertisingGeoCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CidrAdvertisingGeoCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CidrAdvertisingGeoCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
