// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> BGP peer status details. </summary>
    public partial class BgpPeerStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BgpPeerStatus"/>. </summary>
        internal BgpPeerStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BgpPeerStatus"/>. </summary>
        /// <param name="localAddress"> The virtual network gateway's local address. </param>
        /// <param name="neighbor"> The remote BGP peer. </param>
        /// <param name="asn"> The autonomous system number of the remote BGP peer. </param>
        /// <param name="state"> The BGP peer state. </param>
        /// <param name="connectedDuration"> For how long the peering has been up. </param>
        /// <param name="routesReceived"> The number of routes learned from this peer. </param>
        /// <param name="messagesSent"> The number of BGP messages sent. </param>
        /// <param name="messagesReceived"> The number of BGP messages received. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BgpPeerStatus(string localAddress, string neighbor, long? asn, BgpPeerState? state, TimeSpan? connectedDuration, long? routesReceived, long? messagesSent, long? messagesReceived, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LocalAddress = localAddress;
            Neighbor = neighbor;
            Asn = asn;
            State = state;
            ConnectedDuration = connectedDuration;
            RoutesReceived = routesReceived;
            MessagesSent = messagesSent;
            MessagesReceived = messagesReceived;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The virtual network gateway's local address. </summary>
        public string LocalAddress { get; }
        /// <summary> The remote BGP peer. </summary>
        public string Neighbor { get; }
        /// <summary> The autonomous system number of the remote BGP peer. </summary>
        public long? Asn { get; }
        /// <summary> The BGP peer state. </summary>
        public BgpPeerState? State { get; }
        /// <summary> For how long the peering has been up. </summary>
        public TimeSpan? ConnectedDuration { get; }
        /// <summary> The number of routes learned from this peer. </summary>
        public long? RoutesReceived { get; }
        /// <summary> The number of BGP messages sent. </summary>
        public long? MessagesSent { get; }
        /// <summary> The number of BGP messages received. </summary>
        public long? MessagesReceived { get; }
    }
}
