// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class BgpPeerStatus : IUtf8JsonSerializable, IJsonModel<BgpPeerStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BgpPeerStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BgpPeerStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpPeerStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BgpPeerStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(LocalAddress))
            {
                writer.WritePropertyName("localAddress"u8);
                writer.WriteStringValue(LocalAddress);
            }
            if (options.Format != "W" && Optional.IsDefined(Neighbor))
            {
                writer.WritePropertyName("neighbor"u8);
                writer.WriteStringValue(Neighbor);
            }
            if (options.Format != "W" && Optional.IsDefined(Asn))
            {
                writer.WritePropertyName("asn"u8);
                writer.WriteNumberValue(Asn.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectedDuration))
            {
                writer.WritePropertyName("connectedDuration"u8);
                writer.WriteStringValue(ConnectedDuration.Value, "c");
            }
            if (options.Format != "W" && Optional.IsDefined(RoutesReceived))
            {
                writer.WritePropertyName("routesReceived"u8);
                writer.WriteNumberValue(RoutesReceived.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MessagesSent))
            {
                writer.WritePropertyName("messagesSent"u8);
                writer.WriteNumberValue(MessagesSent.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MessagesReceived))
            {
                writer.WritePropertyName("messagesReceived"u8);
                writer.WriteNumberValue(MessagesReceived.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BgpPeerStatus IJsonModel<BgpPeerStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpPeerStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BgpPeerStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBgpPeerStatus(document.RootElement, options);
        }

        internal static BgpPeerStatus DeserializeBgpPeerStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string localAddress = default;
            string neighbor = default;
            long? asn = default;
            BgpPeerState? state = default;
            TimeSpan? connectedDuration = default;
            long? routesReceived = default;
            long? messagesSent = default;
            long? messagesReceived = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("localAddress"u8))
                {
                    localAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("neighbor"u8))
                {
                    neighbor = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("asn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    asn = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new BgpPeerState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("connectedDuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectedDuration = property.Value.GetTimeSpan("c");
                    continue;
                }
                if (property.NameEquals("routesReceived"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    routesReceived = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("messagesSent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    messagesSent = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("messagesReceived"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    messagesReceived = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BgpPeerStatus(
                localAddress,
                neighbor,
                asn,
                state,
                connectedDuration,
                routesReceived,
                messagesSent,
                messagesReceived,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BgpPeerStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpPeerStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BgpPeerStatus)} does not support writing '{options.Format}' format.");
            }
        }

        BgpPeerStatus IPersistableModel<BgpPeerStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BgpPeerStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBgpPeerStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BgpPeerStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BgpPeerStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
