// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The BGP peer state. </summary>
    public readonly partial struct BgpPeerState : IEquatable<BgpPeerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BgpPeerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BgpPeerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string StoppedValue = "Stopped";
        private const string IdleValue = "Idle";
        private const string ConnectingValue = "Connecting";
        private const string ConnectedValue = "Connected";

        /// <summary> Unknown. </summary>
        public static BgpPeerState Unknown { get; } = new BgpPeerState(UnknownValue);
        /// <summary> Stopped. </summary>
        public static BgpPeerState Stopped { get; } = new BgpPeerState(StoppedValue);
        /// <summary> Idle. </summary>
        public static BgpPeerState Idle { get; } = new BgpPeerState(IdleValue);
        /// <summary> Connecting. </summary>
        public static BgpPeerState Connecting { get; } = new BgpPeerState(ConnectingValue);
        /// <summary> Connected. </summary>
        public static BgpPeerState Connected { get; } = new BgpPeerState(ConnectedValue);
        /// <summary> Determines if two <see cref="BgpPeerState"/> values are the same. </summary>
        public static bool operator ==(BgpPeerState left, BgpPeerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BgpPeerState"/> values are not the same. </summary>
        public static bool operator !=(BgpPeerState left, BgpPeerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BgpPeerState"/>. </summary>
        public static implicit operator BgpPeerState(string value) => new BgpPeerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BgpPeerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BgpPeerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
