// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Backend address synchronous mode for the backend pool. </summary>
    public readonly partial struct BackendAddressSyncMode : IEquatable<BackendAddressSyncMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackendAddressSyncMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackendAddressSyncMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string ManualValue = "Manual";

        /// <summary> Automatic. </summary>
        public static BackendAddressSyncMode Automatic { get; } = new BackendAddressSyncMode(AutomaticValue);
        /// <summary> Manual. </summary>
        public static BackendAddressSyncMode Manual { get; } = new BackendAddressSyncMode(ManualValue);
        /// <summary> Determines if two <see cref="BackendAddressSyncMode"/> values are the same. </summary>
        public static bool operator ==(BackendAddressSyncMode left, BackendAddressSyncMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackendAddressSyncMode"/> values are not the same. </summary>
        public static bool operator !=(BackendAddressSyncMode left, BackendAddressSyncMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackendAddressSyncMode"/>. </summary>
        public static implicit operator BackendAddressSyncMode(string value) => new BackendAddressSyncMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackendAddressSyncMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackendAddressSyncMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
