// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Details on latency for a time series. </summary>
    public partial class AzureReachabilityReportLatencyInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureReachabilityReportLatencyInfo"/>. </summary>
        internal AzureReachabilityReportLatencyInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AzureReachabilityReportLatencyInfo"/>. </summary>
        /// <param name="timeStamp"> The time stamp. </param>
        /// <param name="score"> The relative latency score between 1 and 100, higher values indicating a faster connection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureReachabilityReportLatencyInfo(DateTimeOffset? timeStamp, int? score, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TimeStamp = timeStamp;
            Score = score;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The time stamp. </summary>
        public DateTimeOffset? TimeStamp { get; }
        /// <summary> The relative latency score between 1 and 100, higher values indicating a faster connection. </summary>
        public int? Score { get; }
    }
}
