// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Azure reachability report details. </summary>
    public partial class AzureReachabilityReport
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureReachabilityReport"/>. </summary>
        /// <param name="aggregationLevel"> The aggregation level of Azure reachability report. Can be Country, State or City. </param>
        /// <param name="providerLocation"> Parameters that define a geographic location. </param>
        /// <param name="reachabilityReport"> List of Azure reachability report items. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="aggregationLevel"/>, <paramref name="providerLocation"/> or <paramref name="reachabilityReport"/> is null. </exception>
        internal AzureReachabilityReport(string aggregationLevel, AzureReachabilityReportLocation providerLocation, IEnumerable<AzureReachabilityReportItem> reachabilityReport)
        {
            Argument.AssertNotNull(aggregationLevel, nameof(aggregationLevel));
            Argument.AssertNotNull(providerLocation, nameof(providerLocation));
            Argument.AssertNotNull(reachabilityReport, nameof(reachabilityReport));

            AggregationLevel = aggregationLevel;
            ProviderLocation = providerLocation;
            ReachabilityReport = reachabilityReport.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AzureReachabilityReport"/>. </summary>
        /// <param name="aggregationLevel"> The aggregation level of Azure reachability report. Can be Country, State or City. </param>
        /// <param name="providerLocation"> Parameters that define a geographic location. </param>
        /// <param name="reachabilityReport"> List of Azure reachability report items. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureReachabilityReport(string aggregationLevel, AzureReachabilityReportLocation providerLocation, IReadOnlyList<AzureReachabilityReportItem> reachabilityReport, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AggregationLevel = aggregationLevel;
            ProviderLocation = providerLocation;
            ReachabilityReport = reachabilityReport;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AzureReachabilityReport"/> for deserialization. </summary>
        internal AzureReachabilityReport()
        {
        }

        /// <summary> The aggregation level of Azure reachability report. Can be Country, State or City. </summary>
        public string AggregationLevel { get; }
        /// <summary> Parameters that define a geographic location. </summary>
        public AzureReachabilityReportLocation ProviderLocation { get; }
        /// <summary> List of Azure reachability report items. </summary>
        public IReadOnlyList<AzureReachabilityReportItem> ReachabilityReport { get; }
    }
}
