// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The operation mode for Threat Intel. </summary>
    public readonly partial struct AzureFirewallThreatIntelMode : IEquatable<AzureFirewallThreatIntelMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureFirewallThreatIntelMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureFirewallThreatIntelMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertValue = "Alert";
        private const string DenyValue = "Deny";
        private const string OffValue = "Off";

        /// <summary> Alert. </summary>
        public static AzureFirewallThreatIntelMode Alert { get; } = new AzureFirewallThreatIntelMode(AlertValue);
        /// <summary> Deny. </summary>
        public static AzureFirewallThreatIntelMode Deny { get; } = new AzureFirewallThreatIntelMode(DenyValue);
        /// <summary> Off. </summary>
        public static AzureFirewallThreatIntelMode Off { get; } = new AzureFirewallThreatIntelMode(OffValue);
        /// <summary> Determines if two <see cref="AzureFirewallThreatIntelMode"/> values are the same. </summary>
        public static bool operator ==(AzureFirewallThreatIntelMode left, AzureFirewallThreatIntelMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureFirewallThreatIntelMode"/> values are not the same. </summary>
        public static bool operator !=(AzureFirewallThreatIntelMode left, AzureFirewallThreatIntelMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureFirewallThreatIntelMode"/>. </summary>
        public static implicit operator AzureFirewallThreatIntelMode(string value) => new AzureFirewallThreatIntelMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureFirewallThreatIntelMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureFirewallThreatIntelMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
