// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Name of an Azure Firewall SKU. </summary>
    public readonly partial struct AzureFirewallSkuName : IEquatable<AzureFirewallSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureFirewallSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureFirewallSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzfwVnetValue = "AZFW_VNet";
        private const string AzfwHubValue = "AZFW_Hub";

        /// <summary> AZFW_VNet. </summary>
        public static AzureFirewallSkuName AzfwVnet { get; } = new AzureFirewallSkuName(AzfwVnetValue);
        /// <summary> AZFW_Hub. </summary>
        public static AzureFirewallSkuName AzfwHub { get; } = new AzureFirewallSkuName(AzfwHubValue);
        /// <summary> Determines if two <see cref="AzureFirewallSkuName"/> values are the same. </summary>
        public static bool operator ==(AzureFirewallSkuName left, AzureFirewallSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureFirewallSkuName"/> values are not the same. </summary>
        public static bool operator !=(AzureFirewallSkuName left, AzureFirewallSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureFirewallSkuName"/>. </summary>
        public static implicit operator AzureFirewallSkuName(string value) => new AzureFirewallSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureFirewallSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureFirewallSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
