// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The flags type to be captured. </summary>
    public readonly partial struct AzureFirewallPacketCaptureFlagsType : IEquatable<AzureFirewallPacketCaptureFlagsType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureFirewallPacketCaptureFlagsType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureFirewallPacketCaptureFlagsType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FinValue = "fin";
        private const string SynValue = "syn";
        private const string RstValue = "rst";
        private const string PushValue = "push";
        private const string AckValue = "ack";
        private const string UrgValue = "urg";

        /// <summary> fin. </summary>
        public static AzureFirewallPacketCaptureFlagsType Fin { get; } = new AzureFirewallPacketCaptureFlagsType(FinValue);
        /// <summary> syn. </summary>
        public static AzureFirewallPacketCaptureFlagsType Syn { get; } = new AzureFirewallPacketCaptureFlagsType(SynValue);
        /// <summary> rst. </summary>
        public static AzureFirewallPacketCaptureFlagsType Rst { get; } = new AzureFirewallPacketCaptureFlagsType(RstValue);
        /// <summary> push. </summary>
        public static AzureFirewallPacketCaptureFlagsType Push { get; } = new AzureFirewallPacketCaptureFlagsType(PushValue);
        /// <summary> ack. </summary>
        public static AzureFirewallPacketCaptureFlagsType Ack { get; } = new AzureFirewallPacketCaptureFlagsType(AckValue);
        /// <summary> urg. </summary>
        public static AzureFirewallPacketCaptureFlagsType Urg { get; } = new AzureFirewallPacketCaptureFlagsType(UrgValue);
        /// <summary> Determines if two <see cref="AzureFirewallPacketCaptureFlagsType"/> values are the same. </summary>
        public static bool operator ==(AzureFirewallPacketCaptureFlagsType left, AzureFirewallPacketCaptureFlagsType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureFirewallPacketCaptureFlagsType"/> values are not the same. </summary>
        public static bool operator !=(AzureFirewallPacketCaptureFlagsType left, AzureFirewallPacketCaptureFlagsType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureFirewallPacketCaptureFlagsType"/>. </summary>
        public static implicit operator AzureFirewallPacketCaptureFlagsType(string value) => new AzureFirewallPacketCaptureFlagsType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureFirewallPacketCaptureFlagsType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureFirewallPacketCaptureFlagsType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
