// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Properties of a NAT rule. </summary>
    public partial class AzureFirewallNatRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureFirewallNatRule"/>. </summary>
        public AzureFirewallNatRule()
        {
            SourceAddresses = new ChangeTrackingList<string>();
            DestinationAddresses = new ChangeTrackingList<string>();
            DestinationPorts = new ChangeTrackingList<string>();
            Protocols = new ChangeTrackingList<AzureFirewallNetworkRuleProtocol>();
            SourceIPGroups = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureFirewallNatRule"/>. </summary>
        /// <param name="name"> Name of the NAT rule. </param>
        /// <param name="description"> Description of the rule. </param>
        /// <param name="sourceAddresses"> List of source IP addresses for this rule. </param>
        /// <param name="destinationAddresses"> List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags. </param>
        /// <param name="destinationPorts"> List of destination ports. </param>
        /// <param name="protocols"> Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule. </param>
        /// <param name="translatedAddress"> The translated address for this NAT rule. </param>
        /// <param name="translatedPort"> The translated port for this NAT rule. </param>
        /// <param name="translatedFqdn"> The translated FQDN for this NAT rule. </param>
        /// <param name="sourceIPGroups"> List of source IpGroups for this rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureFirewallNatRule(string name, string description, IList<string> sourceAddresses, IList<string> destinationAddresses, IList<string> destinationPorts, IList<AzureFirewallNetworkRuleProtocol> protocols, string translatedAddress, string translatedPort, string translatedFqdn, IList<string> sourceIPGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Description = description;
            SourceAddresses = sourceAddresses;
            DestinationAddresses = destinationAddresses;
            DestinationPorts = destinationPorts;
            Protocols = protocols;
            TranslatedAddress = translatedAddress;
            TranslatedPort = translatedPort;
            TranslatedFqdn = translatedFqdn;
            SourceIPGroups = sourceIPGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the NAT rule. </summary>
        public string Name { get; set; }
        /// <summary> Description of the rule. </summary>
        public string Description { get; set; }
        /// <summary> List of source IP addresses for this rule. </summary>
        public IList<string> SourceAddresses { get; }
        /// <summary> List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags. </summary>
        public IList<string> DestinationAddresses { get; }
        /// <summary> List of destination ports. </summary>
        public IList<string> DestinationPorts { get; }
        /// <summary> Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule. </summary>
        public IList<AzureFirewallNetworkRuleProtocol> Protocols { get; }
        /// <summary> The translated address for this NAT rule. </summary>
        public string TranslatedAddress { get; set; }
        /// <summary> The translated port for this NAT rule. </summary>
        public string TranslatedPort { get; set; }
        /// <summary> The translated FQDN for this NAT rule. </summary>
        public string TranslatedFqdn { get; set; }
        /// <summary> List of source IpGroups for this rule. </summary>
        public IList<string> SourceIPGroups { get; }
    }
}
