// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The protocol type of a Application Rule resource. </summary>
    public readonly partial struct AzureFirewallApplicationRuleProtocolType : IEquatable<AzureFirewallApplicationRuleProtocolType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureFirewallApplicationRuleProtocolType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureFirewallApplicationRuleProtocolType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "Http";
        private const string HttpsValue = "Https";
        private const string MssqlValue = "Mssql";

        /// <summary> Http. </summary>
        public static AzureFirewallApplicationRuleProtocolType Http { get; } = new AzureFirewallApplicationRuleProtocolType(HttpValue);
        /// <summary> Https. </summary>
        public static AzureFirewallApplicationRuleProtocolType Https { get; } = new AzureFirewallApplicationRuleProtocolType(HttpsValue);
        /// <summary> Mssql. </summary>
        public static AzureFirewallApplicationRuleProtocolType Mssql { get; } = new AzureFirewallApplicationRuleProtocolType(MssqlValue);
        /// <summary> Determines if two <see cref="AzureFirewallApplicationRuleProtocolType"/> values are the same. </summary>
        public static bool operator ==(AzureFirewallApplicationRuleProtocolType left, AzureFirewallApplicationRuleProtocolType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureFirewallApplicationRuleProtocolType"/> values are not the same. </summary>
        public static bool operator !=(AzureFirewallApplicationRuleProtocolType left, AzureFirewallApplicationRuleProtocolType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureFirewallApplicationRuleProtocolType"/>. </summary>
        public static implicit operator AzureFirewallApplicationRuleProtocolType(string value) => new AzureFirewallApplicationRuleProtocolType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureFirewallApplicationRuleProtocolType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureFirewallApplicationRuleProtocolType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
