// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Country details. </summary>
    public partial class AvailableProvidersListCountry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailableProvidersListCountry"/>. </summary>
        internal AvailableProvidersListCountry()
        {
            Providers = new ChangeTrackingList<string>();
            States = new ChangeTrackingList<AvailableProvidersListState>();
        }

        /// <summary> Initializes a new instance of <see cref="AvailableProvidersListCountry"/>. </summary>
        /// <param name="countryName"> The country name. </param>
        /// <param name="providers"> A list of Internet service providers. </param>
        /// <param name="states"> List of available states in the country. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailableProvidersListCountry(string countryName, IReadOnlyList<string> providers, IReadOnlyList<AvailableProvidersListState> states, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CountryName = countryName;
            Providers = providers;
            States = states;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The country name. </summary>
        public string CountryName { get; }
        /// <summary> A list of Internet service providers. </summary>
        public IReadOnlyList<string> Providers { get; }
        /// <summary> List of available states in the country. </summary>
        public IReadOnlyList<AvailableProvidersListState> States { get; }
    }
}
