// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The operation mode for automatically learning private ranges to not be SNAT. </summary>
    public readonly partial struct AutoLearnPrivateRangesMode : IEquatable<AutoLearnPrivateRangesMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoLearnPrivateRangesMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoLearnPrivateRangesMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static AutoLearnPrivateRangesMode Enabled { get; } = new AutoLearnPrivateRangesMode(EnabledValue);
        /// <summary> Disabled. </summary>
        public static AutoLearnPrivateRangesMode Disabled { get; } = new AutoLearnPrivateRangesMode(DisabledValue);
        /// <summary> Determines if two <see cref="AutoLearnPrivateRangesMode"/> values are the same. </summary>
        public static bool operator ==(AutoLearnPrivateRangesMode left, AutoLearnPrivateRangesMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoLearnPrivateRangesMode"/> values are not the same. </summary>
        public static bool operator !=(AutoLearnPrivateRangesMode left, AutoLearnPrivateRangesMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoLearnPrivateRangesMode"/>. </summary>
        public static implicit operator AutoLearnPrivateRangesMode(string value) => new AutoLearnPrivateRangesMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoLearnPrivateRangesMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoLearnPrivateRangesMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
