// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The authorization use status. </summary>
    public readonly partial struct AuthorizationUseStatus : IEquatable<AuthorizationUseStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthorizationUseStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthorizationUseStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string InUseValue = "InUse";

        /// <summary> Available. </summary>
        public static AuthorizationUseStatus Available { get; } = new AuthorizationUseStatus(AvailableValue);
        /// <summary> InUse. </summary>
        public static AuthorizationUseStatus InUse { get; } = new AuthorizationUseStatus(InUseValue);
        /// <summary> Determines if two <see cref="AuthorizationUseStatus"/> values are the same. </summary>
        public static bool operator ==(AuthorizationUseStatus left, AuthorizationUseStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthorizationUseStatus"/> values are not the same. </summary>
        public static bool operator !=(AuthorizationUseStatus left, AuthorizationUseStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthorizationUseStatus"/>. </summary>
        public static implicit operator AuthorizationUseStatus(string value) => new AuthorizationUseStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthorizationUseStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthorizationUseStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
