// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Rule of type application. </summary>
    public partial class ApplicationRule : FirewallPolicyRule
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationRule"/>. </summary>
        public ApplicationRule()
        {
            SourceAddresses = new ChangeTrackingList<string>();
            DestinationAddresses = new ChangeTrackingList<string>();
            Protocols = new ChangeTrackingList<FirewallPolicyRuleApplicationProtocol>();
            TargetFqdns = new ChangeTrackingList<string>();
            TargetUrls = new ChangeTrackingList<string>();
            FqdnTags = new ChangeTrackingList<string>();
            SourceIPGroups = new ChangeTrackingList<string>();
            WebCategories = new ChangeTrackingList<string>();
            HttpHeadersToInsert = new ChangeTrackingList<FirewallPolicyHttpHeaderToInsert>();
            RuleType = FirewallPolicyRuleType.ApplicationRule;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationRule"/>. </summary>
        /// <param name="name"> Name of the rule. </param>
        /// <param name="description"> Description of the rule. </param>
        /// <param name="ruleType"> Rule Type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sourceAddresses"> List of source IP addresses for this rule. </param>
        /// <param name="destinationAddresses"> List of destination IP addresses or Service Tags. </param>
        /// <param name="protocols"> Array of Application Protocols. </param>
        /// <param name="targetFqdns"> List of FQDNs for this rule. </param>
        /// <param name="targetUrls"> List of Urls for this rule condition. </param>
        /// <param name="fqdnTags"> List of FQDN Tags for this rule. </param>
        /// <param name="sourceIPGroups"> List of source IpGroups for this rule. </param>
        /// <param name="terminateTLS"> Terminate TLS connections for this rule. </param>
        /// <param name="webCategories"> List of destination azure web categories. </param>
        /// <param name="httpHeadersToInsert"> List of HTTP/S headers to insert. </param>
        internal ApplicationRule(string name, string description, FirewallPolicyRuleType ruleType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> sourceAddresses, IList<string> destinationAddresses, IList<FirewallPolicyRuleApplicationProtocol> protocols, IList<string> targetFqdns, IList<string> targetUrls, IList<string> fqdnTags, IList<string> sourceIPGroups, bool? terminateTLS, IList<string> webCategories, IList<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert) : base(name, description, ruleType, serializedAdditionalRawData)
        {
            SourceAddresses = sourceAddresses;
            DestinationAddresses = destinationAddresses;
            Protocols = protocols;
            TargetFqdns = targetFqdns;
            TargetUrls = targetUrls;
            FqdnTags = fqdnTags;
            SourceIPGroups = sourceIPGroups;
            TerminateTLS = terminateTLS;
            WebCategories = webCategories;
            HttpHeadersToInsert = httpHeadersToInsert;
            RuleType = ruleType;
        }

        /// <summary> List of source IP addresses for this rule. </summary>
        public IList<string> SourceAddresses { get; }
        /// <summary> List of destination IP addresses or Service Tags. </summary>
        public IList<string> DestinationAddresses { get; }
        /// <summary> Array of Application Protocols. </summary>
        public IList<FirewallPolicyRuleApplicationProtocol> Protocols { get; }
        /// <summary> List of FQDNs for this rule. </summary>
        public IList<string> TargetFqdns { get; }
        /// <summary> List of Urls for this rule condition. </summary>
        public IList<string> TargetUrls { get; }
        /// <summary> List of FQDN Tags for this rule. </summary>
        public IList<string> FqdnTags { get; }
        /// <summary> List of source IpGroups for this rule. </summary>
        public IList<string> SourceIPGroups { get; }
        /// <summary> Terminate TLS connections for this rule. </summary>
        public bool? TerminateTLS { get; set; }
        /// <summary> List of destination azure web categories. </summary>
        public IList<string> WebCategories { get; }
        /// <summary> List of HTTP/S headers to insert. </summary>
        public IList<FirewallPolicyHttpHeaderToInsert> HttpHeadersToInsert { get; }
    }
}
