// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> SSL profile of an application gateway. </summary>
    public partial class ApplicationGatewaySslProfile : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationGatewaySslProfile"/>. </summary>
        public ApplicationGatewaySslProfile()
        {
            TrustedClientCertificates = new ChangeTrackingList<WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewaySslProfile"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="trustedClientCertificates"> Array of references to application gateway trusted client certificates. </param>
        /// <param name="sslPolicy"> SSL policy of the application gateway resource. </param>
        /// <param name="clientAuthConfiguration"> Client authentication configuration of the application gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the HTTP listener resource. </param>
        internal ApplicationGatewaySslProfile(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IList<WritableSubResource> trustedClientCertificates, ApplicationGatewaySslPolicy sslPolicy, ApplicationGatewayClientAuthConfiguration clientAuthConfiguration, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            TrustedClientCertificates = trustedClientCertificates;
            SslPolicy = sslPolicy;
            ClientAuthConfiguration = clientAuthConfiguration;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Array of references to application gateway trusted client certificates. </summary>
        public IList<WritableSubResource> TrustedClientCertificates { get; }
        /// <summary> SSL policy of the application gateway resource. </summary>
        public ApplicationGatewaySslPolicy SslPolicy { get; set; }
        /// <summary> Client authentication configuration of the application gateway resource. </summary>
        public ApplicationGatewayClientAuthConfiguration ClientAuthConfiguration { get; set; }
        /// <summary> The provisioning state of the HTTP listener resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
