// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class ApplicationGatewaySslPolicy : IUtf8JsonSerializable, IJsonModel<ApplicationGatewaySslPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApplicationGatewaySslPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApplicationGatewaySslPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewaySslPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationGatewaySslPolicy)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(DisabledSslProtocols))
            {
                writer.WritePropertyName("disabledSslProtocols"u8);
                writer.WriteStartArray();
                foreach (var item in DisabledSslProtocols)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PolicyType))
            {
                writer.WritePropertyName("policyType"u8);
                writer.WriteStringValue(PolicyType.Value.ToString());
            }
            if (Optional.IsDefined(PolicyName))
            {
                writer.WritePropertyName("policyName"u8);
                writer.WriteStringValue(PolicyName.Value.ToString());
            }
            if (Optional.IsCollectionDefined(CipherSuites))
            {
                writer.WritePropertyName("cipherSuites"u8);
                writer.WriteStartArray();
                foreach (var item in CipherSuites)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(MinProtocolVersion))
            {
                writer.WritePropertyName("minProtocolVersion"u8);
                writer.WriteStringValue(MinProtocolVersion.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ApplicationGatewaySslPolicy IJsonModel<ApplicationGatewaySslPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewaySslPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationGatewaySslPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApplicationGatewaySslPolicy(document.RootElement, options);
        }

        internal static ApplicationGatewaySslPolicy DeserializeApplicationGatewaySslPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<ApplicationGatewaySslProtocol> disabledSslProtocols = default;
            ApplicationGatewaySslPolicyType? policyType = default;
            ApplicationGatewaySslPolicyName? policyName = default;
            IList<ApplicationGatewaySslCipherSuite> cipherSuites = default;
            ApplicationGatewaySslProtocol? minProtocolVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("disabledSslProtocols"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ApplicationGatewaySslProtocol> array = new List<ApplicationGatewaySslProtocol>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ApplicationGatewaySslProtocol(item.GetString()));
                    }
                    disabledSslProtocols = array;
                    continue;
                }
                if (property.NameEquals("policyType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    policyType = new ApplicationGatewaySslPolicyType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("policyName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    policyName = new ApplicationGatewaySslPolicyName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cipherSuites"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ApplicationGatewaySslCipherSuite> array = new List<ApplicationGatewaySslCipherSuite>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ApplicationGatewaySslCipherSuite(item.GetString()));
                    }
                    cipherSuites = array;
                    continue;
                }
                if (property.NameEquals("minProtocolVersion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minProtocolVersion = new ApplicationGatewaySslProtocol(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApplicationGatewaySslPolicy(
                disabledSslProtocols ?? new ChangeTrackingList<ApplicationGatewaySslProtocol>(),
                policyType,
                policyName,
                cipherSuites ?? new ChangeTrackingList<ApplicationGatewaySslCipherSuite>(),
                minProtocolVersion,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ApplicationGatewaySslPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewaySslPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ApplicationGatewaySslPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ApplicationGatewaySslPolicy IPersistableModel<ApplicationGatewaySslPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewaySslPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApplicationGatewaySslPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApplicationGatewaySslPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApplicationGatewaySslPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
