// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Ssl cipher suites enums. </summary>
    public readonly partial struct ApplicationGatewaySslCipherSuite : IEquatable<ApplicationGatewaySslCipherSuite>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewaySslCipherSuite"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationGatewaySslCipherSuite(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TlsECDiffieHellmanRsaWithAes256CbcSha384Value = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";
        private const string TlsECDiffieHellmanRsaWithAes128CbcSha256Value = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";
        private const string TlsECDiffieHellmanRsaWithAes256CbcShaValue = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";
        private const string TlsECDiffieHellmanRsaWithAes128CbcShaValue = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";
        private const string TlsDHERsaWithAes256GcmSha384Value = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384";
        private const string TlsDHERsaWithAes128GcmSha256Value = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        private const string TlsDHERsaWithAes256CbcShaValue = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA";
        private const string TlsDHERsaWithAes128CbcShaValue = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
        private const string TlsRsaWithAes256GcmSha384Value = "TLS_RSA_WITH_AES_256_GCM_SHA384";
        private const string TlsRsaWithAes128GcmSha256Value = "TLS_RSA_WITH_AES_128_GCM_SHA256";
        private const string TlsRsaWithAes256CbcSha256Value = "TLS_RSA_WITH_AES_256_CBC_SHA256";
        private const string TlsRsaWithAes128CbcSha256Value = "TLS_RSA_WITH_AES_128_CBC_SHA256";
        private const string TlsRsaWithAes256CbcShaValue = "TLS_RSA_WITH_AES_256_CBC_SHA";
        private const string TlsRsaWithAes128CbcShaValue = "TLS_RSA_WITH_AES_128_CBC_SHA";
        private const string TlsECDiffieHellmanECDsaWithAes256GcmSha384Value = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
        private const string TlsECDiffieHellmanECDsaWithAes128GcmSha256Value = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
        private const string TlsECDiffieHellmanECDsaWithAes256CbcSha384Value = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";
        private const string TlsECDiffieHellmanECDsaWithAes128CbcSha256Value = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";
        private const string TlsECDiffieHellmanECDsaWithAes256CbcShaValue = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";
        private const string TlsECDiffieHellmanECDsaWithAes128CbcShaValue = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";
        private const string TlsDheDssWithAes256CbcSha256Value = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256";
        private const string TlsDheDssWithAes128CbcSha256Value = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256";
        private const string TlsDheDssWithAes256CbcShaValue = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA";
        private const string TlsDheDssWithAes128CbcShaValue = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
        private const string TlsRsaWith3DesEdeCbcShaValue = "TLS_RSA_WITH_3DES_EDE_CBC_SHA";
        private const string TlsDheDssWith3DesEdeCbcShaValue = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
        private const string TlsECDiffieHellmanRsaWithAes128GcmSha256Value = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
        private const string TlsECDiffieHellmanRsaWithAes256GcmSha384Value = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        /// <summary> Determines if two <see cref="ApplicationGatewaySslCipherSuite"/> values are the same. </summary>
        public static bool operator ==(ApplicationGatewaySslCipherSuite left, ApplicationGatewaySslCipherSuite right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationGatewaySslCipherSuite"/> values are not the same. </summary>
        public static bool operator !=(ApplicationGatewaySslCipherSuite left, ApplicationGatewaySslCipherSuite right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationGatewaySslCipherSuite"/>. </summary>
        public static implicit operator ApplicationGatewaySslCipherSuite(string value) => new ApplicationGatewaySslCipherSuite(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationGatewaySslCipherSuite other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationGatewaySslCipherSuite other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
