// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The rule set status. </summary>
    public readonly partial struct ApplicationGatewayRuleSetStatusOption : IEquatable<ApplicationGatewayRuleSetStatusOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayRuleSetStatusOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationGatewayRuleSetStatusOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreviewValue = "Preview";
        private const string GAValue = "GA";
        private const string SupportedValue = "Supported";
        private const string DeprecatedValue = "Deprecated";

        /// <summary> Preview. </summary>
        public static ApplicationGatewayRuleSetStatusOption Preview { get; } = new ApplicationGatewayRuleSetStatusOption(PreviewValue);
        /// <summary> GA. </summary>
        public static ApplicationGatewayRuleSetStatusOption GA { get; } = new ApplicationGatewayRuleSetStatusOption(GAValue);
        /// <summary> Supported. </summary>
        public static ApplicationGatewayRuleSetStatusOption Supported { get; } = new ApplicationGatewayRuleSetStatusOption(SupportedValue);
        /// <summary> Deprecated. </summary>
        public static ApplicationGatewayRuleSetStatusOption Deprecated { get; } = new ApplicationGatewayRuleSetStatusOption(DeprecatedValue);
        /// <summary> Determines if two <see cref="ApplicationGatewayRuleSetStatusOption"/> values are the same. </summary>
        public static bool operator ==(ApplicationGatewayRuleSetStatusOption left, ApplicationGatewayRuleSetStatusOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationGatewayRuleSetStatusOption"/> values are not the same. </summary>
        public static bool operator !=(ApplicationGatewayRuleSetStatusOption left, ApplicationGatewayRuleSetStatusOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationGatewayRuleSetStatusOption"/>. </summary>
        public static implicit operator ApplicationGatewayRuleSetStatusOption(string value) => new ApplicationGatewayRuleSetStatusOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationGatewayRuleSetStatusOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationGatewayRuleSetStatusOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
