// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Rewrite rule set of an application gateway. </summary>
    public partial class ApplicationGatewayRewriteRuleSet : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayRewriteRuleSet"/>. </summary>
        public ApplicationGatewayRewriteRuleSet()
        {
            RewriteRules = new ChangeTrackingList<ApplicationGatewayRewriteRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayRewriteRuleSet"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="rewriteRules"> Rewrite rules in the rewrite rule set. </param>
        /// <param name="provisioningState"> The provisioning state of the rewrite rule set resource. </param>
        internal ApplicationGatewayRewriteRuleSet(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IList<ApplicationGatewayRewriteRule> rewriteRules, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            RewriteRules = rewriteRules;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Rewrite rules in the rewrite rule set. </summary>
        public IList<ApplicationGatewayRewriteRule> RewriteRules { get; }
        /// <summary> The provisioning state of the rewrite rule set resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
