// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Path rule of URL path map of an application gateway. </summary>
    public partial class ApplicationGatewayPathRule : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayPathRule"/>. </summary>
        public ApplicationGatewayPathRule()
        {
            Paths = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayPathRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="paths"> Path rules of URL path map. </param>
        /// <param name="backendAddressPool"> Backend address pool resource of URL path map path rule. </param>
        /// <param name="backendHttpSettings"> Backend http settings resource of URL path map path rule. </param>
        /// <param name="redirectConfiguration"> Redirect configuration resource of URL path map path rule. </param>
        /// <param name="rewriteRuleSet"> Rewrite rule set resource of URL path map path rule. </param>
        /// <param name="loadDistributionPolicy"> Load Distribution Policy resource of URL path map path rule. </param>
        /// <param name="provisioningState"> The provisioning state of the path rule resource. </param>
        /// <param name="firewallPolicy"> Reference to the FirewallPolicy resource. </param>
        internal ApplicationGatewayPathRule(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IList<string> paths, WritableSubResource backendAddressPool, WritableSubResource backendHttpSettings, WritableSubResource redirectConfiguration, WritableSubResource rewriteRuleSet, WritableSubResource loadDistributionPolicy, NetworkProvisioningState? provisioningState, WritableSubResource firewallPolicy) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            Paths = paths;
            BackendAddressPool = backendAddressPool;
            BackendHttpSettings = backendHttpSettings;
            RedirectConfiguration = redirectConfiguration;
            RewriteRuleSet = rewriteRuleSet;
            LoadDistributionPolicy = loadDistributionPolicy;
            ProvisioningState = provisioningState;
            FirewallPolicy = firewallPolicy;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Path rules of URL path map. </summary>
        public IList<string> Paths { get; }
        /// <summary> Backend address pool resource of URL path map path rule. </summary>
        internal WritableSubResource BackendAddressPool { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier BackendAddressPoolId
        {
            get => BackendAddressPool is null ? default : BackendAddressPool.Id;
            set
            {
                if (BackendAddressPool is null)
                    BackendAddressPool = new WritableSubResource();
                BackendAddressPool.Id = value;
            }
        }

        /// <summary> Backend http settings resource of URL path map path rule. </summary>
        internal WritableSubResource BackendHttpSettings { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier BackendHttpSettingsId
        {
            get => BackendHttpSettings is null ? default : BackendHttpSettings.Id;
            set
            {
                if (BackendHttpSettings is null)
                    BackendHttpSettings = new WritableSubResource();
                BackendHttpSettings.Id = value;
            }
        }

        /// <summary> Redirect configuration resource of URL path map path rule. </summary>
        internal WritableSubResource RedirectConfiguration { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier RedirectConfigurationId
        {
            get => RedirectConfiguration is null ? default : RedirectConfiguration.Id;
            set
            {
                if (RedirectConfiguration is null)
                    RedirectConfiguration = new WritableSubResource();
                RedirectConfiguration.Id = value;
            }
        }

        /// <summary> Rewrite rule set resource of URL path map path rule. </summary>
        internal WritableSubResource RewriteRuleSet { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier RewriteRuleSetId
        {
            get => RewriteRuleSet is null ? default : RewriteRuleSet.Id;
            set
            {
                if (RewriteRuleSet is null)
                    RewriteRuleSet = new WritableSubResource();
                RewriteRuleSet.Id = value;
            }
        }

        /// <summary> Load Distribution Policy resource of URL path map path rule. </summary>
        internal WritableSubResource LoadDistributionPolicy { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier LoadDistributionPolicyId
        {
            get => LoadDistributionPolicy is null ? default : LoadDistributionPolicy.Id;
            set
            {
                if (LoadDistributionPolicy is null)
                    LoadDistributionPolicy = new WritableSubResource();
                LoadDistributionPolicy.Id = value;
            }
        }

        /// <summary> The provisioning state of the path rule resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Reference to the FirewallPolicy resource. </summary>
        internal WritableSubResource FirewallPolicy { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier FirewallPolicyId
        {
            get => FirewallPolicy is null ? default : FirewallPolicy.Id;
            set
            {
                if (FirewallPolicy is null)
                    FirewallPolicy = new WritableSubResource();
                FirewallPolicy.Id = value;
            }
        }
    }
}
