// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Load Distribution Algorithm enums. </summary>
    public readonly partial struct ApplicationGatewayLoadDistributionAlgorithm : IEquatable<ApplicationGatewayLoadDistributionAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayLoadDistributionAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationGatewayLoadDistributionAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RoundRobinValue = "RoundRobin";
        private const string LeastConnectionsValue = "LeastConnections";
        private const string IPHashValue = "IpHash";

        /// <summary> RoundRobin. </summary>
        public static ApplicationGatewayLoadDistributionAlgorithm RoundRobin { get; } = new ApplicationGatewayLoadDistributionAlgorithm(RoundRobinValue);
        /// <summary> LeastConnections. </summary>
        public static ApplicationGatewayLoadDistributionAlgorithm LeastConnections { get; } = new ApplicationGatewayLoadDistributionAlgorithm(LeastConnectionsValue);
        /// <summary> IpHash. </summary>
        public static ApplicationGatewayLoadDistributionAlgorithm IPHash { get; } = new ApplicationGatewayLoadDistributionAlgorithm(IPHashValue);
        /// <summary> Determines if two <see cref="ApplicationGatewayLoadDistributionAlgorithm"/> values are the same. </summary>
        public static bool operator ==(ApplicationGatewayLoadDistributionAlgorithm left, ApplicationGatewayLoadDistributionAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationGatewayLoadDistributionAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(ApplicationGatewayLoadDistributionAlgorithm left, ApplicationGatewayLoadDistributionAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationGatewayLoadDistributionAlgorithm"/>. </summary>
        public static implicit operator ApplicationGatewayLoadDistributionAlgorithm(string value) => new ApplicationGatewayLoadDistributionAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationGatewayLoadDistributionAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationGatewayLoadDistributionAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
