// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Http listener of an application gateway. </summary>
    public partial class ApplicationGatewayHttpListener : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayHttpListener"/>. </summary>
        public ApplicationGatewayHttpListener()
        {
            CustomErrorConfigurations = new ChangeTrackingList<ApplicationGatewayCustomError>();
            HostNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayHttpListener"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfiguration"> Frontend IP configuration resource of an application gateway. </param>
        /// <param name="frontendPort"> Frontend port resource of an application gateway. </param>
        /// <param name="protocol"> Protocol of the HTTP listener. </param>
        /// <param name="hostName"> Host name of HTTP listener. </param>
        /// <param name="sslCertificate"> SSL certificate resource of an application gateway. </param>
        /// <param name="sslProfile"> SSL profile resource of the application gateway. </param>
        /// <param name="requireServerNameIndication"> Applicable only if protocol is https. Enables SNI for multi-hosting. </param>
        /// <param name="provisioningState"> The provisioning state of the HTTP listener resource. </param>
        /// <param name="customErrorConfigurations"> Custom error configurations of the HTTP listener. </param>
        /// <param name="firewallPolicy"> Reference to the FirewallPolicy resource. </param>
        /// <param name="hostNames"> List of Host names for HTTP Listener that allows special wildcard characters as well. </param>
        internal ApplicationGatewayHttpListener(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, WritableSubResource frontendIPConfiguration, WritableSubResource frontendPort, ApplicationGatewayProtocol? protocol, string hostName, WritableSubResource sslCertificate, WritableSubResource sslProfile, bool? requireServerNameIndication, NetworkProvisioningState? provisioningState, IList<ApplicationGatewayCustomError> customErrorConfigurations, WritableSubResource firewallPolicy, IList<string> hostNames) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            FrontendIPConfiguration = frontendIPConfiguration;
            FrontendPort = frontendPort;
            Protocol = protocol;
            HostName = hostName;
            SslCertificate = sslCertificate;
            SslProfile = sslProfile;
            RequireServerNameIndication = requireServerNameIndication;
            ProvisioningState = provisioningState;
            CustomErrorConfigurations = customErrorConfigurations;
            FirewallPolicy = firewallPolicy;
            HostNames = hostNames;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Frontend IP configuration resource of an application gateway. </summary>
        internal WritableSubResource FrontendIPConfiguration { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier FrontendIPConfigurationId
        {
            get => FrontendIPConfiguration is null ? default : FrontendIPConfiguration.Id;
            set
            {
                if (FrontendIPConfiguration is null)
                    FrontendIPConfiguration = new WritableSubResource();
                FrontendIPConfiguration.Id = value;
            }
        }

        /// <summary> Frontend port resource of an application gateway. </summary>
        internal WritableSubResource FrontendPort { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier FrontendPortId
        {
            get => FrontendPort is null ? default : FrontendPort.Id;
            set
            {
                if (FrontendPort is null)
                    FrontendPort = new WritableSubResource();
                FrontendPort.Id = value;
            }
        }

        /// <summary> Protocol of the HTTP listener. </summary>
        public ApplicationGatewayProtocol? Protocol { get; set; }
        /// <summary> Host name of HTTP listener. </summary>
        public string HostName { get; set; }
        /// <summary> SSL certificate resource of an application gateway. </summary>
        internal WritableSubResource SslCertificate { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier SslCertificateId
        {
            get => SslCertificate is null ? default : SslCertificate.Id;
            set
            {
                if (SslCertificate is null)
                    SslCertificate = new WritableSubResource();
                SslCertificate.Id = value;
            }
        }

        /// <summary> SSL profile resource of the application gateway. </summary>
        internal WritableSubResource SslProfile { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier SslProfileId
        {
            get => SslProfile is null ? default : SslProfile.Id;
            set
            {
                if (SslProfile is null)
                    SslProfile = new WritableSubResource();
                SslProfile.Id = value;
            }
        }

        /// <summary> Applicable only if protocol is https. Enables SNI for multi-hosting. </summary>
        public bool? RequireServerNameIndication { get; set; }
        /// <summary> The provisioning state of the HTTP listener resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Custom error configurations of the HTTP listener. </summary>
        public IList<ApplicationGatewayCustomError> CustomErrorConfigurations { get; }
        /// <summary> Reference to the FirewallPolicy resource. </summary>
        internal WritableSubResource FirewallPolicy { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier FirewallPolicyId
        {
            get => FirewallPolicy is null ? default : FirewallPolicy.Id;
            set
            {
                if (FirewallPolicy is null)
                    FirewallPolicy = new WritableSubResource();
                FirewallPolicy.Id = value;
            }
        }

        /// <summary> List of Host names for HTTP Listener that allows special wildcard characters as well. </summary>
        public IList<string> HostNames { get; }
    }
}
