// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A web application firewall rule group. </summary>
    public partial class ApplicationGatewayFirewallRuleGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The name of the web application firewall rule group. </param>
        /// <param name="rules"> The rules of the web application firewall rule group. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleGroupName"/> or <paramref name="rules"/> is null. </exception>
        public ApplicationGatewayFirewallRuleGroup(string ruleGroupName, IEnumerable<ApplicationGatewayFirewallRule> rules)
        {
            Argument.AssertNotNull(ruleGroupName, nameof(ruleGroupName));
            Argument.AssertNotNull(rules, nameof(rules));

            RuleGroupName = ruleGroupName;
            Rules = rules.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The name of the web application firewall rule group. </param>
        /// <param name="description"> The description of the web application firewall rule group. </param>
        /// <param name="rules"> The rules of the web application firewall rule group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayFirewallRuleGroup(string ruleGroupName, string description, IList<ApplicationGatewayFirewallRule> rules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleGroupName = ruleGroupName;
            Description = description;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRuleGroup"/> for deserialization. </summary>
        internal ApplicationGatewayFirewallRuleGroup()
        {
        }

        /// <summary> The name of the web application firewall rule group. </summary>
        public string RuleGroupName { get; set; }
        /// <summary> The description of the web application firewall rule group. </summary>
        public string Description { get; set; }
        /// <summary> The rules of the web application firewall rule group. </summary>
        public IList<ApplicationGatewayFirewallRule> Rules { get; }
    }
}
