// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A web application firewall rule. </summary>
    public partial class ApplicationGatewayFirewallRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRule"/>. </summary>
        /// <param name="ruleId"> The identifier of the web application firewall rule. </param>
        public ApplicationGatewayFirewallRule(int ruleId)
        {
            RuleId = ruleId;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRule"/>. </summary>
        /// <param name="ruleId"> The identifier of the web application firewall rule. </param>
        /// <param name="ruleIdString"> The string representation of the web application firewall rule identifier. </param>
        /// <param name="state"> The string representation of the web application firewall rule state. </param>
        /// <param name="action"> The string representation of the web application firewall rule action. </param>
        /// <param name="sensitivity"> The string representation of the web application firewall rule sensitivity. </param>
        /// <param name="description"> The description of the web application firewall rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayFirewallRule(int ruleId, string ruleIdString, ApplicationGatewayWafRuleStateType? state, ApplicationGatewayWafRuleActionType? action, ApplicationGatewayWafRuleSensitivityType? sensitivity, string description, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleId = ruleId;
            RuleIdString = ruleIdString;
            State = state;
            Action = action;
            Sensitivity = sensitivity;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRule"/> for deserialization. </summary>
        internal ApplicationGatewayFirewallRule()
        {
        }

        /// <summary> The identifier of the web application firewall rule. </summary>
        public int RuleId { get; set; }
        /// <summary> The string representation of the web application firewall rule identifier. </summary>
        public string RuleIdString { get; set; }
        /// <summary> The string representation of the web application firewall rule state. </summary>
        public ApplicationGatewayWafRuleStateType? State { get; set; }
        /// <summary> The string representation of the web application firewall rule action. </summary>
        public ApplicationGatewayWafRuleActionType? Action { get; set; }
        /// <summary> The string representation of the web application firewall rule sensitivity. </summary>
        public ApplicationGatewayWafRuleSensitivityType? Sensitivity { get; set; }
        /// <summary> The description of the web application firewall rule. </summary>
        public string Description { get; set; }
    }
}
