// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule. </summary>
    public readonly partial struct ApplicationGatewayFirewallRateLimitDuration : IEquatable<ApplicationGatewayFirewallRateLimitDuration>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallRateLimitDuration"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationGatewayFirewallRateLimitDuration(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneMinValue = "OneMin";
        private const string FiveMinsValue = "FiveMins";

        /// <summary> OneMin. </summary>
        public static ApplicationGatewayFirewallRateLimitDuration OneMin { get; } = new ApplicationGatewayFirewallRateLimitDuration(OneMinValue);
        /// <summary> FiveMins. </summary>
        public static ApplicationGatewayFirewallRateLimitDuration FiveMins { get; } = new ApplicationGatewayFirewallRateLimitDuration(FiveMinsValue);
        /// <summary> Determines if two <see cref="ApplicationGatewayFirewallRateLimitDuration"/> values are the same. </summary>
        public static bool operator ==(ApplicationGatewayFirewallRateLimitDuration left, ApplicationGatewayFirewallRateLimitDuration right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationGatewayFirewallRateLimitDuration"/> values are not the same. </summary>
        public static bool operator !=(ApplicationGatewayFirewallRateLimitDuration left, ApplicationGatewayFirewallRateLimitDuration right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationGatewayFirewallRateLimitDuration"/>. </summary>
        public static implicit operator ApplicationGatewayFirewallRateLimitDuration(string value) => new ApplicationGatewayFirewallRateLimitDuration(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationGatewayFirewallRateLimitDuration other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationGatewayFirewallRateLimitDuration other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
