// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Web application firewall mode. </summary>
    public readonly partial struct ApplicationGatewayFirewallMode : IEquatable<ApplicationGatewayFirewallMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationGatewayFirewallMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DetectionValue = "Detection";
        private const string PreventionValue = "Prevention";

        /// <summary> Detection. </summary>
        public static ApplicationGatewayFirewallMode Detection { get; } = new ApplicationGatewayFirewallMode(DetectionValue);
        /// <summary> Prevention. </summary>
        public static ApplicationGatewayFirewallMode Prevention { get; } = new ApplicationGatewayFirewallMode(PreventionValue);
        /// <summary> Determines if two <see cref="ApplicationGatewayFirewallMode"/> values are the same. </summary>
        public static bool operator ==(ApplicationGatewayFirewallMode left, ApplicationGatewayFirewallMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationGatewayFirewallMode"/> values are not the same. </summary>
        public static bool operator !=(ApplicationGatewayFirewallMode left, ApplicationGatewayFirewallMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationGatewayFirewallMode"/>. </summary>
        public static implicit operator ApplicationGatewayFirewallMode(string value) => new ApplicationGatewayFirewallMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationGatewayFirewallMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationGatewayFirewallMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
