// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Properties of the web application firewall rule set. </summary>
    public partial class ApplicationGatewayFirewallManifestRuleSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallManifestRuleSet"/>. </summary>
        /// <param name="ruleSetType"> The type of the web application firewall rule set. </param>
        /// <param name="ruleSetVersion"> The version of the web application firewall rule set type. </param>
        /// <param name="ruleGroups"> The rule groups of the web application firewall rule set. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleSetType"/>, <paramref name="ruleSetVersion"/> or <paramref name="ruleGroups"/> is null. </exception>
        internal ApplicationGatewayFirewallManifestRuleSet(string ruleSetType, string ruleSetVersion, IEnumerable<ApplicationGatewayFirewallRuleGroup> ruleGroups)
        {
            Argument.AssertNotNull(ruleSetType, nameof(ruleSetType));
            Argument.AssertNotNull(ruleSetVersion, nameof(ruleSetVersion));
            Argument.AssertNotNull(ruleGroups, nameof(ruleGroups));

            RuleSetType = ruleSetType;
            RuleSetVersion = ruleSetVersion;
            Tiers = new ChangeTrackingList<ApplicationGatewayTierType>();
            RuleGroups = ruleGroups.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallManifestRuleSet"/>. </summary>
        /// <param name="ruleSetType"> The type of the web application firewall rule set. </param>
        /// <param name="ruleSetVersion"> The version of the web application firewall rule set type. </param>
        /// <param name="status"> The rule set status. </param>
        /// <param name="tiers"> Tier of an application gateway that support the rule set. </param>
        /// <param name="ruleGroups"> The rule groups of the web application firewall rule set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayFirewallManifestRuleSet(string ruleSetType, string ruleSetVersion, ApplicationGatewayRuleSetStatusOption? status, IReadOnlyList<ApplicationGatewayTierType> tiers, IReadOnlyList<ApplicationGatewayFirewallRuleGroup> ruleGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleSetType = ruleSetType;
            RuleSetVersion = ruleSetVersion;
            Status = status;
            Tiers = tiers;
            RuleGroups = ruleGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallManifestRuleSet"/> for deserialization. </summary>
        internal ApplicationGatewayFirewallManifestRuleSet()
        {
        }

        /// <summary> The type of the web application firewall rule set. </summary>
        public string RuleSetType { get; }
        /// <summary> The version of the web application firewall rule set type. </summary>
        public string RuleSetVersion { get; }
        /// <summary> The rule set status. </summary>
        public ApplicationGatewayRuleSetStatusOption? Status { get; }
        /// <summary> Tier of an application gateway that support the rule set. </summary>
        public IReadOnlyList<ApplicationGatewayTierType> Tiers { get; }
        /// <summary> The rule groups of the web application firewall rule set. </summary>
        public IReadOnlyList<ApplicationGatewayFirewallRuleGroup> RuleGroups { get; }
    }
}
