// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Allows to disable rules within a rule group or an entire rule group. </summary>
    public partial class ApplicationGatewayFirewallDisabledRuleGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallDisabledRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The name of the rule group that will be disabled. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleGroupName"/> is null. </exception>
        public ApplicationGatewayFirewallDisabledRuleGroup(string ruleGroupName)
        {
            Argument.AssertNotNull(ruleGroupName, nameof(ruleGroupName));

            RuleGroupName = ruleGroupName;
            Rules = new ChangeTrackingList<int>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallDisabledRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The name of the rule group that will be disabled. </param>
        /// <param name="rules"> The list of rules that will be disabled. If null, all rules of the rule group will be disabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationGatewayFirewallDisabledRuleGroup(string ruleGroupName, IList<int> rules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleGroupName = ruleGroupName;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationGatewayFirewallDisabledRuleGroup"/> for deserialization. </summary>
        internal ApplicationGatewayFirewallDisabledRuleGroup()
        {
        }

        /// <summary> The name of the rule group that will be disabled. </summary>
        public string RuleGroupName { get; set; }
        /// <summary> The list of rules that will be disabled. If null, all rules of the rule group will be disabled. </summary>
        public IList<int> Rules { get; }
    }
}
